using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        var byY = new Dictionary<long, List<long>>();
        var byX = new Dictionary<long, List<long>>();
        var bySum = new Dictionary<long, long>();
        var byDiff = new Dictionary<long, long>();

        for (int i = 0; i < n; i++)
        {
            var p = Console.ReadLine().Split();
            long x = long.Parse(p[0]);
            long y = long.Parse(p[1]);

            if (!byY.ContainsKey(y)) byY[y] = new List<long>();
            if (!byX.ContainsKey(x)) byX[x] = new List<long>();
            byY[y].Add(x);
            byX[x].Add(y);

            long s = x + y;
            long d = x - y;
            if (!bySum.ContainsKey(s)) bySum[s] = 0;
            if (!byDiff.ContainsKey(d)) byDiff[d] = 0;
            bySum[s]++;
            byDiff[d]++;
        }

        long ans = 0;

        foreach (var kv in byY)
        {
            long even = 0, odd = 0;
            foreach (var x in kv.Value)
                if ((x & 1) == 0) even++; else odd++;
            ans += even * (even - 1) / 2;
            ans += odd * (odd - 1) / 2;
        }

        foreach (var kv in byX)
        {
            long even = 0, odd = 0;
            foreach (var y in kv.Value)
                if ((y & 1) == 0) even++; else odd++;
            ans += even * (even - 1) / 2;
            ans += odd * (odd - 1) / 2;
        }

        foreach (var kv in bySum)
            ans += kv.Value * (kv.Value - 1);

        foreach (var kv in byDiff)
            ans += kv.Value * (kv.Value - 1);

        Console.WriteLine(ans);
    }
}